partial class SearchCustomers : ApplicationBasePage
{

#region  Declare Privates 

	public bool _SearchPerformed = false;
	private System.Diagnostics.Stopwatch _StopWatch = new System.Diagnostics.Stopwatch();

#endregion

#region Page Events

    /// <summary>
    /// Wire up the rest of the events used within the page.  This event is intrinsically called
    /// since the AutoEventWireUp tag is set in the SearchCustomers.aspx source (top of the source).
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, System.EventArgs e)
    {
        lstResults.AfterRequery += new MicroFour.StrataFrame.UI.Web.ListView.AfterRequeryEventHandler(lstResults_AfterRequery);
        lstResults.ListPopulating += new MicroFour.StrataFrame.UI.Web.ListView.ListPopulatingEventHandler(lstResults_ListPopulating);
        lstResults.RowPopulating += new MicroFour.StrataFrame.UI.Web.ListView.RowPopulatingEventHandler(lstResults_RowPopulating);
        cmdClear.Click += new System.EventHandler(cmdClear_Click);
        cmdSearch.Click += new System.EventHandler(cmdSearch_Click);
    }

#endregion

#region  Handled Events 


	protected void lstResults_AfterRequery()
	{
		lblResultsHeader.Text = Customers.Count.ToString("n0") + " Results Found in " + _StopWatch.Elapsed.TotalSeconds.ToString() + " seconds";
	}

	protected void lstResults_ListPopulating(MicroFour.StrataFrame.UI.ListPopulatingEventArgs e)
	{
		lstResults.Rows.Clear();
		e.Parameters[0].Value = Customers;
		e.Parameters[1].Value = MicroFour.StrataFrame.Business.BusinessCloneDataType.ClearAndFillFromDefaultView;
	}

	protected void lstResults_RowPopulating(MicroFour.StrataFrame.UI.Web.RowPopulatingEventArgs e)
	{
		e.Values[0].DisplayValue = "<a href='editcustomers.aspx?pk=" + e.BusinessObject["cust_pk"].ToString() + "'>Edit</a>";
	}

	protected void cmdClear_Click(object sender, System.EventArgs e)
	{
		//-- Clear the text boxes
		txtFirstName.Text = "";
		txtLastName.Text = "";
	}

	protected void cmdSearch_Click(object sender, System.EventArgs e)
	{
		//-- Execute the search
		ExecuteSearch();
	}

#endregion

#region  Search Methods 

	/// <summary>
	/// Executes the search
	/// </summary>
	/// <remarks></remarks>
	private void ExecuteSearch()
	{
		//-- Establish Locals
		System.Data.SqlClient.SqlCommand loCommand = new System.Data.SqlClient.SqlCommand();
		string lcWhere = " WHERE ";
		bool llHadWhere = false;

		//-- Reset and start the stop watch
		_StopWatch.Reset();
		_StopWatch.Start();

		//-- Build the select
		loCommand.CommandText = "SELECT TOP 100 * FROM customers ";

		//-- Build the WHERE clause
		if (txtFirstName.Text.Length > 0)
		{
			//-- Indicate that a statement has been added
			llHadWhere = true;

			//-- Update the WHERE command
			lcWhere += "cust_FirstName LIKE @cust_FirstName";

			//-- Add the parameter
			loCommand.Parameters.Add("@cust_FirstName", System.Data.SqlDbType.VarChar);
			loCommand.Parameters["@cust_FirstName"].Value = txtFirstName.Text + "%";
		}

		//-- Check the last name
		if (txtLastName.Text.Length > 0)
		{
			//-- See if an AND needs to the added
			if (llHadWhere)
			{
				lcWhere += " AND ";
			}

			//-- Indicate that a statement has been added
			llHadWhere = true;

			//-- Update the WHERE command
			lcWhere += "cust_LastName LIKE @cust_LastName";

			//-- Add the parameter
			loCommand.Parameters.Add("@cust_LastName", System.Data.SqlDbType.VarChar);
			loCommand.Parameters["@cust_LastName"].Value = txtLastName.Text + "%";
		}

		//-- Update the command
		if (llHadWhere)
		{
			loCommand.CommandText += lcWhere;
		}

		//-- Set the order
		loCommand.CommandText += " ORDER BY cust_LastName, cust_FirstName";

		//-- Execute the command
		Customers.FillDataTable(loCommand);

		//-- Stop the watch
		_StopWatch.Stop();

		//-- Set the search flag
		this._SearchPerformed = true;

		//-- Load the results display
		SetResultsDisplay();
	}

	/// <summary>
	/// Set the results display
	/// </summary>
	/// <remarks></remarks>
	private void SetResultsDisplay()
	{
		//-- Set the results display
		if (this.Customers.Count == 0)
		{
			this.lblResults.Text = "No Results Found";
			this.lblResults.Visible = true;
		}
		else
		{
			this.lblResults.Visible = false;
			this.lstResults.Visible = true;
			this.lstResults.Requery();
		}
	}

#endregion

}
